# freeze_kernel_manifest.py
import glob, hashlib, json, os, re, numpy as np

OUT = "data/kernels/kernel_manifest.json"

def sha256(p):
    h = hashlib.sha256()
    with open(p, "rb") as f:
        for ch in iter(lambda: f.read(1<<20), b""):
            h.update(ch)
    return h.hexdigest()

def main():
    rows = []
    for p in sorted(glob.glob("data/kernels/kernel_*_L*.npy")):
        m = re.search(r"kernel_(SU[23])_L(\d+)\.npy$", os.path.basename(p))
        if not m: continue
        gauge, L = m.group(1), int(m.group(2))
        arr = np.load(p)
        rows.append({
            "gauge": gauge,
            "L": L,
            "path": p.replace("\\","/"),
            "size": int(arr.size),
            "expected": int(2*L*L),
            "sha256": sha256(p),
        })
    with open(OUT, "w", encoding="utf-8") as f:
        json.dump({"kernels": rows}, f, indent=2)
    print(f"[OK] wrote {OUT} with {len(rows)} entries")

if __name__ == "__main__":
    main()
